package game;

import java.awt.Color;



public class MovingBlockSprite extends SolidBlockSprite implements MovingObject {
	
	
	public static final int MOVE_MODE_NORTH_SOUTH = 0;
	public static final int MOVE_MODE_EAST_WEST = 1;
	
	public char moveDir;
	public int minXPos;
	public int maxXPos;
	public int minYPos;
	public int maxYPos;
	public int moveMode;
	
	public int moveSpeed;
	
	private String name;
	
	public MovingBlockSprite(boolean isResource, String resourceName, int theWidth, int theHeight, int xPosition, int yPosition, Color transparency, boolean passThru, 
			int theMoveMode, int minMovePos, int maxMovePos, char initDir, int speed, String theName, PonyPanel ponyPanel) {
		
		super(isResource, resourceName, theWidth, theHeight, xPosition, yPosition, transparency, passThru, ponyPanel);
		
		moveSpeed = speed;
		name = theName;
		
		switch(theMoveMode) {
		case MOVE_MODE_NORTH_SOUTH:
			minXPos = xPosition;
			maxXPos = xPosition;
			minYPos = minMovePos;
			maxYPos = maxMovePos;
			if(initDir != 'u' && initDir != 'd')
				moveDir = 'u';
			else
				moveDir = initDir;
			if(yPosition > maxYPos)
				this.setyPos(maxYPos);
			else if(yPosition < minYPos)
				this.setyPos(minYPos);
			break;
		case MOVE_MODE_EAST_WEST:
			minYPos = yPosition;
			maxYPos = yPosition;
			minXPos = minMovePos;
			maxXPos = maxMovePos;
			if(initDir != 'l' && initDir != 'r')
				moveDir = 'l';
			else
				moveDir = initDir; 
			if(xPosition > maxXPos)
				this.setxPos(maxXPos);
			else if(xPosition < minXPos)
				this.setxPos(minXPos);
			break;
		}
		
		
	}
	
	
	public void pushPlayerLeftIfNeeded(PlayerSprite player) {
		
		if(this.isPassThrough())
			return;
		
		IntRect playerRect = player.getNextPosCollisionRect();
		IntRect thisRect = this.getCollisionRect();
		
		if(playerRect.getMinY() > thisRect.getMaxY() || playerRect.getMaxY() < thisRect.getMinY())
			return;
		
		if(playerRect.getMinX() > thisRect.getMaxX())
			return;
		
		int potentialPush = thisRect.getMinX() - playerRect.getMaxX();
		
		if(potentialPush <= this.moveSpeed) {
			player.pushPlayerX(-(moveSpeed - potentialPush), this, false);
		}
		
		
	}
	
	public void pushPlayerRightIfNeeded(PlayerSprite player) {

		if(this.isPassThrough())
			return;
		
		IntRect playerRect = player.getNextPosCollisionRect();
		IntRect thisRect = this.getCollisionRect();
		
		if(playerRect.getMinY() > thisRect.getMaxY() || playerRect.getMaxY() < thisRect.getMinY())
			return;
		
		if(playerRect.getMaxX() < thisRect.getMinX())
			return;
		
		int potentialPush = playerRect.getMinX() - thisRect.getMaxX();
		
		if(potentialPush <= this.moveSpeed) {
			player.pushPlayerX((moveSpeed - potentialPush), this, false);
		}
		
		
	}
	
	public void update(PlayerSprite player) {
		
		Diagnostic.print("now entering update method, dir " + Character.toString(moveDir) + ", floor: " + this.getCollisionRectMinY(), "moving block \'" + getName() + "\'");
		
		switch(moveDir) {
		case 'l':
			if(this.isPlayerCurrentlyOnBlock(player)) {
//				player.setxPos(player.getxPos() - moveSpeed);
				player.pushPlayerX(-moveSpeed, this, false);
			} else {
				pushPlayerLeftIfNeeded(player);
			}
			
			this.setxPos(Math.max(this.getxPos() - moveSpeed, this.minXPos));
			
			if(this.getxPos() <= this.minXPos) {
				moveDir = 'r';
			}
			break;
		case 'r':
			if(this.isPlayerCurrentlyOnBlock(player)) {
//				player.setxPos(player.getxPos() + moveSpeed);
				player.pushPlayerX(moveSpeed, this, false);
			} else {
				pushPlayerRightIfNeeded(player);
			}
			this.setxPos(Math.min(this.getxPos() + moveSpeed, this.maxXPos));
			
			if(this.getxPos() >= this.maxXPos) {
				moveDir = 'l';
			}
			break;
		case 'u':
			
//			int playerPush = this.isPlayerCurrentlyOnBlockOrCloseEnoughAbove(player);
			boolean playerPush = this.isPlayerCurrentlyOnBlockOrCloseEnoughAbove(player);
			
			Diagnostic.print("moving up; playerPush is: " + playerPush, "moving block \'" + getName() + "\'");
			
			if(playerPush) {
//				System.err.println("<><>DELME now moving the player up..." + name);
//				player.setyPos(player.getyPos() - moveSpeed);
//				player.pushPlayerY(-Math.min(Math.max(playerPush, 1), moveSpeed), this);
				player.pushPlayerY(-moveSpeed, this, false);
			}
			this.setyPos(Math.max(this.getyPos() - moveSpeed, this.minYPos));
			
			if(this.getyPos() <= this.minYPos) {
				moveDir = 'd';
			}
			break;
		case 'd':
			if(this.isPlayerCurrentlyOnBlock(player)) {
//				System.err.println("<><>DELME now moving the player down...");
//				player.setyPos(player.getyPos() + moveSpeed);
				player.pushPlayerY(moveSpeed, this, false);
			} else {
				int diff = movingDownWillCreatePlayerCollisionReturnDifference(player);
				if(diff != Integer.MIN_VALUE) {
					player.pushPlayerY(diff, this, true);
//					player.setyPos(player.getyPos() + diff);
//					System.out.println("<><>DELME There we have it!  diff: " + diff);
				}
			}
			this.setyPos(Math.min(this.getyPos() + moveSpeed, this.maxYPos));
			
			if(this.getyPos() >= this.maxYPos) {
				moveDir = 'u';
			}
			break;
		}
		

		Diagnostic.print("now leaving update method, dir " + Character.toString(moveDir) + ", floor: " + this.getCollisionRectMinY(), "moving block \'" + getName() + "\'");
		
		
	}
	
	

	public boolean isPlayerCurrentlyOnBlockOrCloseEnoughAbove(PlayerSprite player) {
		
		IntRect playerRect = player.getCurrentPosCollisionRect();
		IntRect blockRect = getCollisionRect();
		
		if(playerRect.getMaxX() < blockRect.getMinX() || playerRect.getMinX() > blockRect.getMaxX())
//			return Integer.MIN_VALUE;
			return false;
		
		double difference = playerRect.getMaxY() + 1.0 - blockRect.getMinY();
		
		
//		if(getName() != null && getName().equals("vblock2"))
//			System.err.println("<><>DELME =======================================  player.getMaxY is: " + playerRect.getMaxY() + ", block's minY is: " + blockRect.getMinY());
		
		return difference <= 1.0 && difference > -moveSpeed;
//		return (int) difference;
		
	}
	
	public IntRect getCollisionRect() {
		return new IntRect(this.getxPos() - this.getWidth() / 2, this.getyPos() - this.getHeight() / 2, this.getWidth(), this.getHeight());
	}
	
	@Override
	public int getCollisionRectMinY() {
//		System.out.println("<><>DELME it's asking for my min Y; what'll it be?  " + (this.getyPos() - this.getHeight() / 2 - (this.getHeight() % 2)));
		return this.getyPos() - this.getHeight() / 2 - (this.getHeight() % 2);
	}
	
	public int getCollisionRectMaxY() {
		return this.getyPos() - this.getHeight() / 2 - (this.getHeight() % 2) + this.getHeight();
	}
	

	public int getCollisionRectMinX() {
		return this.getxPos() - this.getWidth() / 2 - (this.getWidth() % 2);
	}
	
	public int getCollisionRectMaxX() {
		return this.getxPos() - this.getWidth() / 2 - (this.getWidth() % 2) + this.getWidth();
	}
	
	
	public MovingBlockSprite(CustomImageDataII image, int theWidth, int theHeight, int xPosition, int yPosition, boolean passThru, 
			int theMoveMode, int minMovePos, int maxMovePos, char initDir, int speed, String theName) {
		
		super(image, theWidth, theHeight, xPosition, yPosition,  passThru);
		
		moveSpeed = speed;
		name = theName;
		
		switch(theMoveMode) {
		case MOVE_MODE_NORTH_SOUTH:
			minXPos = xPosition;
			maxXPos = xPosition;
			minYPos = minMovePos;
			maxYPos = maxMovePos;
			if(initDir != 'u' && initDir != 'd')
				moveDir = 'u';
			else
				moveDir = initDir;
			if(yPosition > maxYPos)
				this.setyPos(maxYPos);
			else if(yPosition < minYPos)
				this.setyPos(minYPos);
			break;
		case MOVE_MODE_EAST_WEST:
			minYPos = yPosition;
			maxYPos = yPosition;
			minXPos = minMovePos;
			maxXPos = maxMovePos;
			if(initDir != 'l' && initDir != 'r')
				moveDir = 'l';
			else
				moveDir = initDir; 
			if(xPosition > maxXPos)
				this.setxPos(maxXPos);
			else if(xPosition < minXPos)
				this.setxPos(minXPos);
			break;
		}
		
		
	}
	
	public String getName() {
		return name;
	}
	
	
	public int movingDownWillCreatePlayerCollisionReturnDifference(PlayerSprite player) {
		
		IntRect thisRect = this.getCollisionRect();
		IntRect playerRect = player.getCurrentPosCollisionRect();
		
		if(playerRect.getMinX() > thisRect.getMaxX() || playerRect.getMaxX() < thisRect.getMinX())
			return Integer.MIN_VALUE;
		
		
		int currentCollisionRectMaxY = (int) thisRect.getMaxY();
		int playerMinY = (int) playerRect.getMinY();
		
		
		if(currentCollisionRectMaxY < playerMinY && currentCollisionRectMaxY + this.moveSpeed >= playerMinY)
			return currentCollisionRectMaxY + this.moveSpeed + 1 - playerMinY;
		
		return Integer.MIN_VALUE;
		
	}
	
	@Override
	public char getDir() {
		return moveDir;
	}
	
	public int getMoveSpeed() {
		return moveSpeed;
	}
	
}
